/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.tracking.google;

import java.util.Random;
import net.ftb.tracking.google.AnalyticsConfigData;
import net.ftb.tracking.google.AnalyticsRequestData;
import net.ftb.tracking.google.URIEncoder;

public class GoogleAnalytics {
    public static final String URL_PREFIX = "http://www.google-analytics.com/__utm.gif";
    private AnalyticsConfigData config;
    private Random random = new Random((long)(Math.random() * 9.223372036854776E18));

    public GoogleAnalytics(AnalyticsConfigData argConfig) {
        this.config = argConfig;
    }

    public String getGoogleAnalyticsVersion() {
        return "4.7.2";
    }

    public String buildURL(AnalyticsRequestData argData) {
        StringBuilder sb = new StringBuilder();
        sb.append(URL_PREFIX);
        long now = System.currentTimeMillis();
        sb.append("?utmwv=").append(this.getGoogleAnalyticsVersion());
        sb.append("&utmn=").append(this.random.nextInt());
        if (argData.getHostName() != null) {
            sb.append("&utmhn=").append(this.getURIString(argData.getHostName()));
        }
        if (argData.getEventAction() != null && argData.getEventCategory() != null) {
            sb.append("&utmt=event");
            String category = this.getURIString(argData.getEventCategory());
            String action = this.getURIString(argData.getEventAction());
            sb.append("&utme=5(").append(category).append("*").append(action);
            if (argData.getEventLabel() != null) {
                sb.append("*").append(this.getURIString(argData.getEventLabel()));
            }
            sb.append(")");
            if (argData.getEventValue() != null) {
                sb.append("(").append(argData.getEventValue()).append(")");
            }
        } else if (argData.getEventAction() != null || argData.getEventCategory() != null) {
            throw new IllegalArgumentException("Event tracking must have both a category and an action");
        }
        if (this.config.getEncoding() != null) {
            sb.append("&utmcs=").append(this.getURIString(this.config.getEncoding()));
        } else {
            sb.append("&utmcs=-");
        }
        if (this.config.getScreenResolution() != null) {
            sb.append("&utmsr=").append(this.getURIString(this.config.getScreenResolution()));
        }
        if (this.config.getColorDepth() != null) {
            sb.append("&utmsc=").append(this.getURIString(this.config.getColorDepth()));
        }
        if (this.config.getUserLanguage() != null) {
            sb.append("&utmul=").append(this.getURIString(this.config.getUserLanguage()));
        }
        sb.append("&utmje=1");
        if (this.config.getFlashVersion() != null) {
            sb.append("&utmfl=").append(this.getURIString(this.config.getFlashVersion()));
        }
        if (argData.getPageTitle() != null) {
            sb.append("&utmdt=").append(this.getURIString(argData.getPageTitle()));
        }
        sb.append("&utmhid=").append(this.random.nextInt());
        if (argData.getPageURL() != null) {
            sb.append("&utmp=").append(this.getURIString(argData.getPageURL()));
        }
        sb.append("&utmac=").append(this.config.getTrackingCode());
        String utmcsr = this.getURIString(argData.getUtmcsr());
        String utmccn = this.getURIString(argData.getUtmccn());
        String utmctr = this.getURIString(argData.getUtmctr());
        String utmcmd = this.getURIString(argData.getUtmcmd());
        String utmcct = this.getURIString(argData.getUtmcct());
        int hostnameHash = this.hostnameHash(argData.getHostName());
        int visitorId = this.config.getVisitorData().getVisitorId();
        long timestampFirst = this.config.getVisitorData().getTimestampFirst();
        long timestampPrevious = this.config.getVisitorData().getTimestampPrevious();
        long timestampCurrent = this.config.getVisitorData().getTimestampCurrent();
        int visits = this.config.getVisitorData().getVisits();
        sb.append("&utmcc=__utma%3D").append(hostnameHash).append(".").append(visitorId).append(".").append(timestampFirst).append(".").append(timestampPrevious).append(".").append(timestampCurrent).append(".").append(visits).append("%3B%2B__utmz%3D").append(hostnameHash).append(".").append(timestampCurrent).append(".1.1.utmcsr%3D").append(utmcsr).append("%7Cutmccn%3D").append(utmccn).append("%7Cutmcmd%3D").append(utmcmd).append(utmctr != null ? "%7Cutmctr%3D" + utmctr : "").append(utmcct != null ? "%7Cutmcct%3D" + utmcct : "").append("%3B&gaq=1");
        return sb.toString();
    }

    private String getURIString(String argString) {
        return argString == null ? null : URIEncoder.encodeURI(argString);
    }

    private int hostnameHash(String hostname) {
        return 999;
    }

    public void resetSession() {
        this.config.getVisitorData().resetSession();
    }
}

